/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   Atomic and Native type definitions
::   Copyright   :   (C)2002-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   None
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \file AtomicTypes.h
 \brief Atomic and native type definitions
*/

#ifndef __ATOMICTYPES_H
#define __ATOMICTYPES_H

/* --- TYPEDEF ----------------------------------------------------------------------------------------------*/
#pragma pack(1)

/*! \brief  1 byte implementation of a boolean */
typedef unsigned char               bool1;
/*! \brief  1 byte implementation of a volatile boolean */
typedef volatile unsigned char      vbool1;

/*! \brief  1 byte implementation of a signed integer */
typedef signed char                 sint1;
/*! \brief  1 byte implementation of a volatile signed integer */
typedef volatile signed char        vsint1;

/*! \brief  2 byte implementation of a signed integer */
typedef short                       sint2;
/*! \brief  2 byte implementation of a volatile signed integer */
typedef volatile short              vsint2;

/*! \brief  4 byte implementation of a signed integer */
typedef int                         sint4;
/*! \brief  4 byte implementation of a volatile signed integer */
typedef volatile int                vsint4;

/*! \brief  1 byte implementation of a unsigned integer */
typedef unsigned char               uint1;
/*! \brief  1 byte implementation of a volatile unsigned integer */
typedef volatile unsigned char      vuint1;

/*! \brief  2 byte implementation of a unsigned integer */
typedef unsigned short              uint2;
/*! \brief  4 byte implementation of a volatile unsigned integer */
typedef volatile unsigned short     vuint2;

/*! \brief  4 byte implementation of a unsigned integer */
typedef unsigned int                uint4;
/*! \brief  4 byte implementation of a volatile unsigned integer */
typedef volatile unsigned int       vuint4;

#if (__FLOATING_POINT == 1)
typedef float                       real4;
typedef double                      real8;
#endif

#pragma pack()

/* --- FUNCTION PROTOTYPES ----------------------------------------------------------------------------------*/

#endif /* __ATOMICTYPES_H*/

